/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.RedactableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.Destroyable;
import com.floragunn.searchguard.configuration.Hideable;
import com.floragunn.searchguard.configuration.StaticDefinable;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class SgDynamicConfiguration<T>
implements ToXContent,
Document<Object>,
RedactableDocument,
ComponentStateProvider,
Destroyable {
    private static final Logger log = LogManager.getLogger(SgDynamicConfiguration.class);
    private final CType<T> ctype;
    private final ComponentState componentState;
    private final OrderedImmutableMap<String, T> centries;
    private long seqNo = -2L;
    private long primaryTerm = 0L;
    private String uninterpolatedJson;
    private long docVersion = -1L;
    private final ValidationErrors validationErrors;
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{env\\.([\\w]+)((\\:\\-)?[\\w]*)\\}");
    private static final Pattern ENVBC_PATTERN = Pattern.compile("\\$\\{envbc\\.([\\w]+)((\\:\\-)?[\\w]*)\\}");
    private static final Pattern ENVBASE64_PATTERN = Pattern.compile("\\$\\{envbase64\\.([\\w]+)((\\:\\-)?[\\w]*)\\}");

    public static <T> SgDynamicConfiguration<T> empty(CType<T> type) {
        return new SgDynamicConfiguration<T>(type, OrderedImmutableMap.empty());
    }

    public static <T> SgDynamicConfiguration<T> of(CType<T> type, String k1, T v1) {
        return new SgDynamicConfiguration<T>(type, OrderedImmutableMap.of((Object)k1, v1));
    }

    public static <T> SgDynamicConfiguration<T> of(CType<T> type, String k1, T v1, String k2, T v2) {
        return new SgDynamicConfiguration<T>(type, OrderedImmutableMap.of((Object)k1, v1, (Object)k2, v2));
    }

    public static <T> SgDynamicConfiguration<T> of(CType<T> type, Map<String, T> entries) {
        return new SgDynamicConfiguration<T>(type, OrderedImmutableMap.of(entries));
    }

    public static <T> ValidationResult<SgDynamicConfiguration<T>> fromJson(String uninterpolatedJson, CType<T> ctype, long docVersion, long seqNo, long primaryTerm, ConfigurationRepository.Context parserContext) throws DocumentParseException, ConfigValidationException {
        String jsonString = ctype.isReplaceLegacyEnvVars() ? SgDynamicConfiguration.replaceEnvVars(uninterpolatedJson, ctype) : uninterpolatedJson;
        return SgDynamicConfiguration.fromDocNode(DocNode.wrap((Object)DocReader.json().splitAttributesAtDotsStartingAtDepth(1).read(jsonString)), uninterpolatedJson, ctype, docVersion, seqNo, primaryTerm, parserContext);
    }

    public static <T> ValidationResult<SgDynamicConfiguration<T>> fromMap(Map<String, ?> map, CType<T> ctype, ConfigurationRepository.Context parserContext) throws ConfigValidationException {
        return SgDynamicConfiguration.fromDocNode(DocNode.wrap(map), null, ctype, -1L, -1L, -1L, parserContext);
    }

    public static <T> ValidationResult<SgDynamicConfiguration<T>> fromDocNode(DocNode docNode, String uninterpolatedJson, CType<T> ctype, long docVersion, long seqNo, long primaryTerm, ConfigurationRepository.Context parserContext) {
        Parser.ReturningValidationResult<T, ConfigurationRepository.Context> parser = ctype.getParser();
        if (parser == null) {
            throw new IllegalArgumentException("Unsupported ctype " + ctype);
        }
        OrderedImmutableMap.Builder entries = new OrderedImmutableMap.Builder(docNode.size());
        ValidationErrors validationErrors = new ValidationErrors();
        for (Map.Entry entry : docNode.entrySet()) {
            String id = (String)entry.getKey();
            if (id.startsWith("_sg")) continue;
            try {
                ValidationResult parsedEntry = parser.parse(DocNode.wrap(entry.getValue()), (Parser.Context)parserContext);
                if (parsedEntry.hasResult()) {
                    entries.put((Object)id, parsedEntry.peek());
                }
                validationErrors.add(ctype.getArity() == CType.Arity.SINGLE ? null : id, parsedEntry.getValidationErrors());
            }
            catch (Exception e) {
                log.error("Unexpected exception while parsing " + entry, (Throwable)e);
                validationErrors.add(new ValidationError(ctype.getArity() == CType.Arity.SINGLE ? null : id, e.getMessage()).cause((Throwable)e));
            }
        }
        return new ValidationResult(new SgDynamicConfiguration<T>(ctype, entries.build(), seqNo, primaryTerm, docVersion, uninterpolatedJson, validationErrors), validationErrors);
    }

    private SgDynamicConfiguration(CType<T> ctype, OrderedImmutableMap<String, T> entries) {
        this.ctype = ctype;
        this.centries = entries;
        this.componentState = new ComponentState(0, "config", ctype.getName());
        this.validationErrors = new ValidationErrors();
    }

    private SgDynamicConfiguration(CType<T> ctype, OrderedImmutableMap<String, T> entries, long seqNo, long primaryTerm, long docVersion, String uninterpolatedJson, ValidationErrors validationErrors) {
        this.centries = entries;
        this.ctype = ctype;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.uninterpolatedJson = uninterpolatedJson;
        this.docVersion = docVersion;
        this.validationErrors = validationErrors;
        this.componentState = new ComponentState(0, "config", ctype.getName());
        this.componentState.setConfigVersion(docVersion);
        if (validationErrors.hasErrors()) {
            log.error("Errors in configuration " + ctype + "\n" + validationErrors.toDebugString());
            this.componentState.setState(ComponentState.State.PARTIALLY_INITIALIZED, "has_errors");
            this.componentState.addDetail(validationErrors.toBasicObject());
        } else {
            this.componentState.initialized();
        }
    }

    public String getETag() {
        return this.primaryTerm + "." + this.seqNo;
    }

    public OrderedImmutableMap<String, T> getCEntries() {
        return this.centries;
    }

    public SgDynamicConfiguration<T> with(String key, T entry) {
        return new SgDynamicConfiguration<T>(this.ctype, this.centries.with((Object)key, entry), this.seqNo, this.primaryTerm, this.docVersion, null, this.validationErrors);
    }

    public SgDynamicConfiguration<T> with(Map<String, T> map) {
        return new SgDynamicConfiguration<T>(this.ctype, this.centries.with((ImmutableMap)OrderedImmutableMap.of(map)), this.seqNo, this.primaryTerm, this.docVersion, this.uninterpolatedJson, this.validationErrors);
    }

    public SgDynamicConfiguration<T> without(String key) {
        return new SgDynamicConfiguration<T>(this.ctype, this.centries.without((Object)key), this.seqNo, this.primaryTerm, this.docVersion, null, this.validationErrors);
    }

    public SgDynamicConfiguration<T> withoutStatic() {
        OrderedImmutableMap.Builder entries = new OrderedImmutableMap.Builder(this.centries.size());
        for (Map.Entry<String, T> entry : new HashMap<String, T>(this.centries).entrySet()) {
            if (entry.getValue() instanceof StaticDefinable && ((StaticDefinable)entry.getValue()).isStatic()) continue;
            entries.put((Object)entry.getKey(), entry.getValue());
        }
        return new SgDynamicConfiguration<T>(this.ctype, entries.build(), this.seqNo, this.primaryTerm, this.docVersion, this.uninterpolatedJson, this.validationErrors);
    }

    public SgDynamicConfiguration<T> withoutHidden() {
        OrderedImmutableMap.Builder entries = new OrderedImmutableMap.Builder(this.centries.size());
        for (Map.Entry<String, T> entry : new HashMap<String, T>(this.centries).entrySet()) {
            if (entry.getValue() instanceof Hideable && ((Hideable)entry.getValue()).isHidden()) continue;
            entries.put((Object)entry.getKey(), entry.getValue());
        }
        return new SgDynamicConfiguration<T>(this.ctype, entries.build(), this.seqNo, this.primaryTerm, this.docVersion, this.uninterpolatedJson, this.validationErrors);
    }

    public SgDynamicConfiguration<T> only(String key) {
        Object entry = this.centries.get((Object)key);
        if (entry == null) {
            return SgDynamicConfiguration.empty(this.ctype);
        }
        return new SgDynamicConfiguration<T>(this.ctype, OrderedImmutableMap.of((Object)key, (Object)entry), this.seqNo, this.primaryTerm, this.docVersion, null, this.validationErrors);
    }

    public T getCEntry(String key) {
        return (T)this.centries.get((Object)key);
    }

    public boolean exists(String key) {
        return this.centries.containsKey((Object)key);
    }

    public String toString() {
        if (this.primaryTerm == 0L) {
            return this.ctype + "@[none]";
        }
        return this.ctype + "@" + this.primaryTerm + "." + this.seqNo + "/n:" + this.centries.size();
    }

    public Object toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.centries.size() + 1);
        for (Map.Entry entry : this.centries.entrySet()) {
            result.put((String)entry.getKey(), ((Document)entry.getValue()).toBasicObject());
        }
        return result;
    }

    public Object toRedactedBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.centries.size() + 1);
        for (Map.Entry entry : this.centries.entrySet()) {
            if (entry.getValue() instanceof RedactableDocument) {
                result.put((String)entry.getKey(), ((RedactableDocument)entry.getValue()).toRedactedBasicObject());
                continue;
            }
            result.put((String)entry.getKey(), ((Document)entry.getValue()).toBasicObject());
        }
        return result;
    }

    public Object toRedactedLegacyBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.centries.size() + 1);
        for (Map.Entry entry : this.centries.entrySet()) {
            if (entry.getValue() instanceof HasLegacyFormat) {
                result.put((String)entry.getKey(), ((HasLegacyFormat)entry.getValue()).toRedactedLegacyBasicObject());
                continue;
            }
            if (entry.getValue() instanceof RedactableDocument) {
                result.put((String)entry.getKey(), ((RedactableDocument)entry.getValue()).toRedactedBasicObject());
                continue;
            }
            result.put((String)entry.getKey(), ((Document)entry.getValue()).toDeepBasicObject());
        }
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.uninterpolatedJson != null) {
            builder.rawValue((InputStream)new ByteArrayInputStream(this.uninterpolatedJson.getBytes(Charsets.UTF_8)), XContentType.JSON);
        } else {
            if (Document.class.isAssignableFrom(this.ctype.getType())) {
                return builder.value(this.toBasicObject());
            }
            builder.startObject();
            for (Map.Entry entry : this.centries.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                builder.field(key, ((Document)value).toBasicObject());
            }
            builder.endObject();
        }
        return builder;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean documentExists() {
        return this.seqNo >= 0L && this.primaryTerm >= 0L;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public CType<T> getCType() {
        return this.ctype;
    }

    public Class<T> getImplementingClass() {
        if (this.ctype == null) {
            return null;
        }
        return this.ctype.getType();
    }

    public long getDocVersion() {
        return this.docVersion;
    }

    public String getUninterpolatedJson() {
        return this.uninterpolatedJson;
    }

    public ValidationErrors getValidationErrors() {
        return this.validationErrors;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    @Override
    public void destroy() {
        if (!Destroyable.class.isAssignableFrom(this.ctype.getClass())) {
            return;
        }
        for (Object entry : this.centries.values()) {
            if (!(entry instanceof Destroyable)) continue;
            try {
                ((Destroyable)entry).destroy();
            }
            catch (Exception e) {
                log.error("Error while destroying " + entry, (Throwable)e);
            }
        }
    }

    @Deprecated
    private static String replaceEnvVars(String in, CType<?> ctype) {
        if (in == null || in.isEmpty()) {
            return in;
        }
        return SgDynamicConfiguration.replaceEnvVarsBC(SgDynamicConfiguration.replaceEnvVarsNonBC(SgDynamicConfiguration.replaceEnvVarsBase64(in, ctype), ctype), ctype);
    }

    @Deprecated
    private static String replaceEnvVarsNonBC(String in, CType<?> ctype) {
        Matcher matcher = ENV_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            log.error("DEPRECATION WARNING: The environment variable " + matcher.group() + " in the configuration " + ctype + " is deprecated. Support will be removed in the next version. Please move to configuration variables.");
            String replacement = SgDynamicConfiguration.resolveEnvVar(matcher.group(1), matcher.group(2), false);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Deprecated
    private static String replaceEnvVarsBC(String in, CType<?> ctype) {
        Matcher matcher = ENVBC_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            log.error("DEPRECATION WARNING: The environment variable " + matcher.group() + " in the configuration " + ctype + " is deprecated. Support will be removed in the next version. Please move to configuration variables.");
            String replacement = SgDynamicConfiguration.resolveEnvVar(matcher.group(1), matcher.group(2), true);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Deprecated
    private static String replaceEnvVarsBase64(String in, CType<?> ctype) {
        Matcher matcher = ENVBASE64_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            log.error("DEPRECATION WARNING: The environment variable " + matcher.group() + " in the configuration " + ctype + " is deprecated. Support will be removed in the next version. Please move to configuration variables.");
            String replacement = SgDynamicConfiguration.resolveEnvVar(matcher.group(1), matcher.group(2), false);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(new String(Base64.getDecoder().decode(replacement), StandardCharsets.UTF_8)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Deprecated
    private static String resolveEnvVar(String envVarName, String mode, boolean bc) {
        String envVarValue = System.getenv(envVarName);
        if (envVarValue == null || envVarValue.isEmpty()) {
            if (mode != null && mode.startsWith(":-") && mode.length() > 2) {
                return bc ? SgDynamicConfiguration.hash(mode.substring(2).toCharArray()) : mode.substring(2);
            }
            return null;
        }
        return bc ? SgDynamicConfiguration.hash(envVarValue.toCharArray()) : envVarValue;
    }

    @Deprecated
    private static String hash(char[] clearTextPassword) {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        String hash = OpenBSDBCrypt.generate((char[])Objects.requireNonNull(clearTextPassword), (byte[])salt, (int)12);
        Arrays.fill(salt, (byte)0);
        Arrays.fill(clearTextPassword, '\u0000');
        return hash;
    }

    public static interface HasLegacyFormat {
        public Object toRedactedLegacyBasicObject();
    }
}

